/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.report.action;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;

import jp.mosp.kintai.action.AttendanceTotalAction;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceListVo;

import jp.mosp.report.dao.AttendanceTableDao;
import jp.mosp.report.dto.AttendanceTableDto;

public class AttendanceTableAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_ATTENDANCE_TABLE 	= "R1051";

	// tB[h
	private List<AttendanceTableDto>	titleList	;

	//vOϐ
//	int		i			= 0;
	int		r			= 0;	//Row(s) 0`
//	int		c			= 0;	//Cel() 0`
	int		pageno		= 0;	//y[W
//	int		strl		= 0;	//Jnʒu
	int		endl		= 68;	//ŏIʒugetLastRow()Ŏ擾
	int		endpagel	= 72;	//1y[W̍ŏIs
	int		gyol		= 2;	//ׂ̉s
	int		titlel		= 3;	//1y[W̃^Cgʒu
	int		firstl		= 7;	//1y[W̖׊Jnʒu
	int		lastl		= 68;	//1y[W̖׍ŏIs(vs͊܂܂Ȃ)
	int		totall		= 69;	//1y[W̍vs
	int		printcnt	= 0;
	String	file1		= "";
	//GNZEZԍ
	int    cc[]   = {1,4,6,8,13,18,23,28,33,39,43,47,51,55,61};
	//׍ڒ` 0-14i@15-29i
//	String    detail[]   = new String[30];
	//vڒ` 0-14i@15-29i
	int    total[]    = new int[30];
	//e[uڒ`
//	String	sikyuym		= "";
//	String	simei		= "";
//	int		nen			= 0;
//	int		tuki		= 0;
//	int		hi			= 0;
//	String	wbiko		= "";
//	String	yobi[];
//	int		dw1;

	/**
	 * RXgN^
	 */
	public AttendanceTableAction() {
		super();
		setNeedProcSeq(false);
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {		
		// DBRlNV擾
		getConnection();
		// VO̎擾
		AttendanceListVo vo = new AttendanceListVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_ATTENDANCE_TABLE)) {
			vo = (AttendanceListVo)getStoredVo(CommonConst.VO_ATTENDANCE_LIST);
			if (vo == null) {
				vo = new AttendanceListVo();
			}
			vo.initVo(cfg, msg, cmd, aspUser, user);
			vo.clearMessage();
			vo.clearErrField();
			// p[^擾
			vo.setParams(request);
			// \
			Date targetMonth = util.getYearMonth(vo.getPltYear(), vo.getPltMonth());
			// f[^擾
			getTitleList(vo.getHidKCode());
			getAttendanceList(vo.getHidKCode(), targetMonth);
			// [쐬
			PoiUtility poi = makeAttendanceTable(targetMonth);
			// [ݒ
			StringBuffer fileName = new StringBuffer();
			fileName.append(util.convDateToStringYearMonth(targetMonth));
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
			fileName.append(vo.getHidKCode());
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
			fileName.append(CommonConst.FILE_ATTENDANCE_TABLE);
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
			request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * Ζ\쐬
	 * @param targetMonth       Ώی
	 * @return PoiUtilityCX^X
	 * @throws Exception 
	 */
	private PoiUtility makeAttendanceTable(	Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + CommonConst.TEMPLATE_M_KINMUHYO);
		// wb_[ݒ
		prtTitle(targetMonth, poi);
		// Wvf[^z쐬
		makePoiAttendance(poi);
		// f[^ݒ
		prtDetail(targetMonth, poi);
		if (printcnt > 0) {
			// v
			prtTotalg(poi);         
			prtEnding(poi);
		}				
		return poi;
	}

	/**
	 * ^Cgf[^擾
	 * @param kcode ЈR[h
	 * @throws Exception
	 */
	private void getTitleList(String kcode) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// 
		AttendanceTableDao dao = new AttendanceTableDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		titleList = new ArrayList<AttendanceTableDto>();
		titleList = dao.findForCondition(kcode);
	}

	/**
	 * ^Cg\bh
	 * @param targetMonth
	 * @param poi
	 * @throws Exception
	 */
	private void prtTitle(Date targetMonth, PoiUtility poi) throws Exception{
		// y[W
		pageno += 1;
		// ^CgʒuZo
		r = (pageno - 1) * endpagel + (titlel - 1);
		// ^Cg,t
		r += 0;
		// N
		poi.prtItem( r,  7, MospUtility.getYear (targetMonth));
		poi.prtItem( r, 12, MospUtility.getMonth(targetMonth));
		// 
		Iterator<AttendanceTableDto> it = titleList.iterator();
		while(it.hasNext()){
			AttendanceTableDto dto = it.next();
			poi.prtItem( r, 24, dto.getSimei());
			// 
			poi.prtItem( r, 43, dto.getSName());
			r += 2;
			// ׈ʒuZo
			r = (pageno - 1) * endpagel + (firstl - 1 - gyol);
		}
	}

	/**
	 * ׈\bh
	 * @param targetMonth
	 * @param poi
	 * @throws Exception
	 */
	private void prtDetail(Date targetMonth, PoiUtility poi) throws Exception{
		// ŊmF
		chkNewPage(targetMonth, poi);   
		// iڐݒ
		for (int i = 0; i < aryAttendance.length; i++) {
			// Ž
			poi.addMergedRegion(r,  8, r,12);
			poi.addMergedRegion(r, 13, r,17);
			poi.addMergedRegion(r, 18, r,22);
			poi.addMergedRegion(r, 23, r,27);
			poi.addMergedRegion(r, 28, r,32);
			poi.addMergedRegion(r, 33, r,38);
			poi.addMergedRegion(r, 39, r,42);
			poi.addMergedRegion(r, 43, r,46);
			poi.addMergedRegion(r, 47, r,50);
			poi.addMergedRegion(r, 51, r,54);
			poi.addMergedRegion(r, 55, r,60);
			poi.addMergedRegion(r, 61, r,67);

			poi.addMergedRegion(r+1,  8, r+1,12);
			poi.addMergedRegion(r+1, 13, r+1,17);
			poi.addMergedRegion(r+1, 18, r+1,22);
			poi.addMergedRegion(r+1, 23, r+1,27);
			poi.addMergedRegion(r+1, 28, r+1,32);
			poi.addMergedRegion(r+1, 33, r+1,38);
			poi.addMergedRegion(r+1, 39, r+1,42);
			poi.addMergedRegion(r+1, 43, r+1,46);
			poi.addMergedRegion(r+1, 47, r+1,50);
			poi.addMergedRegion(r+1, 51, r+1,54);
			poi.addMergedRegion(r+1, 55, r+1,60);
			poi.addMergedRegion(r+1, 61, r+1,67);

			// i
			poi.prtItem( r, cc[0], aryAttendance[i][1]);
			poi.prtItem( r, cc[1], aryAttendance[i][2]);
			poi.prtItem( r, cc[2], aryAttendance[i][3]);
			poi.prtItem( r, cc[3], aryAttendance[i][4]);
			if(!aryAttendance[i][4].equals("")){
				poi.prtItem( r, cc[4], aryAttendance[i][5]);
				poi.prtItem( r, cc[5], aryAttendance[i][6]);

				poi.prtItem( r, cc[6], aryAttendance[i][7]);
				poi.prtItem( r, cc[7], aryAttendance[i][8]);
				poi.prtItem( r, cc[8], aryAttendance[i][9]);

				poi.prtItem( r, cc[9],  aryAttendance[i][10]);
				poi.prtItem( r, cc[10], aryAttendance[i][11]);
				poi.prtItem( r, cc[11], aryAttendance[i][12]);

				poi.prtItem( r, cc[12], aryAttendance[i][13]);
				poi.prtItem( r, cc[13], aryAttendance[i][14]);
				poi.prtItem( r, cc[14], aryAttendance[i][15]);

				// i
				poi.prtItem( r+1, cc[3], aryAttendance[i][16]);
				poi.prtItem( r+1, cc[4], aryAttendance[i][17]);
				poi.prtItem( r+1, cc[5], aryAttendance[i][18]);

				poi.prtItem( r+1, cc[7], aryAttendance[i][19]);
				poi.prtItem( r+1, cc[8], aryAttendance[i][20]);

				poi.prtItem( r+1, cc[9],  aryAttendance[i][21]);
				poi.prtItem( r+1, cc[10], aryAttendance[i][22]);
				poi.prtItem( r+1, cc[11], aryAttendance[i][23]);

				poi.prtItem( r+1, cc[12], aryAttendance[i][24]);
				poi.prtItem( r+1, cc[13], aryAttendance[i][25]);
			}
			r++;
			r++;		
			// ׈
			printcnt += 1;
		}
	}

	/**
	 * v\bh
	 * @param poi
	 * @throws Exception
	 */
	private void prtTotalg(PoiUtility poi) throws Exception{	
		// vʒuZo
		r = (pageno - 1) * endpagel + (totall - 1);

		poi.addMergedRegion(r,  8, r,12);
		poi.addMergedRegion(r, 13, r,17);
		poi.addMergedRegion(r, 18, r,22);
		poi.addMergedRegion(r, 23, r,27);
		poi.addMergedRegion(r, 28, r,32);
		poi.addMergedRegion(r, 33, r,38);
		poi.addMergedRegion(r, 39, r,42);
		poi.addMergedRegion(r, 43, r,46);
		poi.addMergedRegion(r, 47, r,50);
		poi.addMergedRegion(r, 51, r,54);
		poi.addMergedRegion(r, 55, r,60);
		poi.addMergedRegion(r, 61, r,67);

		poi.addMergedRegion(r+1,  8, r+1,12);
		poi.addMergedRegion(r+1, 13, r+1,17);
		poi.addMergedRegion(r+1, 18, r+1,22);
		poi.addMergedRegion(r+1, 23, r+1,27);
		poi.addMergedRegion(r+1, 28, r+1,32);
		poi.addMergedRegion(r+1, 33, r+1,38);
		poi.addMergedRegion(r+1, 39, r+1,42);
		poi.addMergedRegion(r+1, 43, r+1,46);
		poi.addMergedRegion(r+1, 47, r+1,50);
		poi.addMergedRegion(r+1, 51, r+1,54);
		poi.addMergedRegion(r+1, 55, r+1,60);
		poi.addMergedRegion(r+1, 61, r+1,67);

		// i
		poi.prtItem( r, cc[4], getHourString(util.convIntegerTimeToDoubleTime(total[4])));
		poi.prtItem( r, cc[5], getHourString(util.convIntegerTimeToDoubleTime(total[5])));
		poi.prtItem( r, cc[6], getHourString(util.convIntegerTimeToDoubleTime(total[6])));
		poi.prtItem( r, cc[7], getHourString(util.convIntegerTimeToDoubleTime(total[7])));

		poi.prtItem( r, cc[9], total[9]);
		poi.prtItem( r, cc[10], total[10]);
		poi.prtItem( r, cc[11], total[11]);

		poi.prtItem( r, cc[13], getHourString(util.convIntegerTimeToDoubleTime(total[13])));

		// i
		poi.prtItem( r+1, cc[4], getHourString(util.convIntegerTimeToDoubleTime(total[19])));
		poi.prtItem( r+1, cc[5], getHourString(util.convIntegerTimeToDoubleTime(total[20])));

		poi.prtItem( r+1, cc[7], getHourString(util.convIntegerTimeToDoubleTime(total[22])));

		poi.prtItem( r+1, cc[9], total[24]);
		poi.prtItem( r+1, cc[10], total[25]);
		poi.prtItem( r+1, cc[11], total[26]);

		// ׈
		printcnt += 1;
	}

	/**
	 * Vō쐬\bh
	 * @param targetMonth
	 * @param poi
	 * @throws Exception
	 */
	private void chkNewPage(
			Date targetMonth,
			PoiUtility poi
	) throws Exception{
		// I[v
		if (pageno == 0) {
			// PageĐ
			crtNewDoc(poi);
			// ^Cg			
			prtTitle(targetMonth, poi);
		}
		if (r >= ((pageno - 1) * endpagel + (lastl - gyol))) {
			// I[o[t[͍ŏ̈̎A^Cg
			prtTitle(targetMonth, poi);
		}
		// s
		r += gyol;
	}

	/**
	 * Vō쐬\bh
	 * @param poi
	 * @throws Exception
	 */
	private void crtNewDoc(PoiUtility poi) throws Exception{
		poi.crtNewDocR(0, file1);
		// ŏIs擾
		endl  = poi.getLastRow();
	}

	/**
	 * Wvf[^z쐬
	 * @param poi
	 * @throws Exception
	 */
	private void makePoiAttendance(PoiUtility poi) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		aryAttendance = new String[count][40];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// t
			aryAttendance[i][1] = String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));

			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					if (isAvailableWorkType(dto)) {
						aryAttendance[i][4 ] = dto.getSyJikoku();
						aryAttendance[i][5 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						aryAttendance[i][6 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getZaJikan()));
						aryAttendance[i][7 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSnJikan()));
						aryAttendance[i][8 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTiJikan()));
						aryAttendance[i][9 ] = util.getCodeName(dto.getTiRiyuu(), getMosPCodeArray(CommonConst.TID_LATE_REASON));
						aryAttendance[i][10] = String.valueOf(dto.getSyokuji());
						aryAttendance[i][11] = String.valueOf(dto.getCyoku2());
						aryAttendance[i][12] = String.valueOf(dto.getHoka1());
						aryAttendance[i][13] = dto.getSHankyuKb();
						aryAttendance[i][14] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKKJikan()));
						aryAttendance[i][15] = dto.getKKRiyuu();
						aryAttendance[i][16] = dto.getTaJikoku();
						aryAttendance[i][17] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
						aryAttendance[i][18] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKsJikan()));
						aryAttendance[i][19] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSoJikan()));
						aryAttendance[i][20] = util.getCodeName(dto.getSoRiyuu(), getMosPCodeArray(CommonConst.TID_LEAVE_EARLY_REASON));
						aryAttendance[i][21] = String.valueOf(dto.getCyoku1());
						aryAttendance[i][22] = String.valueOf(dto.getCyoku3());
						aryAttendance[i][23] = String.valueOf(dto.getHoka2());
						aryAttendance[i][24] = dto.getTHankyuKb();
						aryAttendance[i][25] = dto.getDaiKyuJyu();

						total[4] 	+=  dto.getKinmuJi();
						total[5] 	+=  dto.getZaJikan();
						total[6] 	+=  dto.getZaJikan();
						total[7] 	+=  dto.getTiJikan();
						total[9] 	+=  dto.getSyokuji();
						total[10] 	+=  dto.getCyoku2();
						total[11] 	+=  dto.getHoka1();
						total[13] 	+=  dto.getKKJikan();
						total[19] 	+=  dto.getKyukeiJi();
						total[20] 	+=  dto.getKsJikan();
						total[22] 	+=  dto.getSoJikan();
						total[24] 	+=  dto.getCyoku1();
						total[25] 	+=  dto.getCyoku3();						
						total[26] 	+=  dto.getHoka2();

						// t蓖
						if (aryAttendance[i][31].equals("")) {
							poi.prtItem(i + 6, 30, "");
						} else {
							poi.prtItem(i + 6, 30, Integer.parseInt(aryAttendance[i][31]));
						}
					}
					aryAttendance[i][3 ] = util.getCodeName(dto.getKinmu() , getWorkTypeArrayAllWithWeekHoliday());
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}

	/**
	 * [I
	 * @param poi
	 * @throws Exception
	 */
	private void prtEnding(PoiUtility poi) throws Exception{
		// W
		// I̍ŏ̍s
		r = pageno * endpagel;
		String syori =  "delete";
		// cs폜
		for (; r <= endl; r += 1) {
			if (syori.equals("delete")) {
				poi.dltRow(r);
			}
		}
	}

}